#!/bin/sh

# This script takes in a .csv file of gps data and splits it into
# multiple files of max 2000 entries, all containing the proper
# header contained in the original file. Once split, these files can
# then be uploaded into visual gps representation web tools such as
# Google's My Maps.

# Usage:
#	csv_split.sh <input file> [out file prefix]

[ $# -lt 1 ] && {
	echo "Usage: $0 <input.csv> [out file prefix] [entries per file]"
	exit
}
[ -f $1 ] || {
	echo "Invalid file: $1"
	exit
}

IN=${1}
OUT=${2:-"${1%%.csv}-split"}
ENTRIES=${3:-2000}
FIRST=$(head -n 1 $IN)
SPLITS=1
OFFSET=2

NUMLINES=$(wc -l $IN | cut -d' ' -f1)

while [ $OFFSET -le $NUMLINES ]; do
	FILENAME=${OUT}${SPLITS}.csv
	echo $FIRST > $FILENAME
	sed -n "${OFFSET},$((OFFSET+ENTRIES-1))p" $IN >> $FILENAME
	OFFSET=$((OFFSET + ENTRIES-1))
	SPLITS=$((SPLITS + 1))
done

echo "Created $((SPLITS - 1)) files"

## END ##
